from pydantic import BaseModel, EmailStr
from typing import Optional


class UserRead(BaseModel):
    id: int
    email: EmailStr
    first_name: Optional[str]
    last_name: Optional[str]
    role: str
    club_id: Optional[int]
    is_active: bool

    class Config:
        from_attributes = True
