from pydantic import BaseModel, EmailStr
from typing import Optional


class LoginRequest(BaseModel):
    email: EmailStr
    password: str


class Token(BaseModel):
    access_token: str
    token_type: str
    role: Optional[str]


class TrainerInviteCreate(BaseModel):
    generated_by_id: int
    club_name: str
    city: Optional[str]


class ParentInviteCreate(BaseModel):
    generated_by_id: int
    club_id: int


class TrainerRegister(BaseModel):
    token: Optional[str] = None  # Secure token for new system
    invite_token: Optional[str] = None  # Legacy support
    admin_id: Optional[int] = None  # Legacy direct admin ID (deprecated)
    club_name: str
    city: Optional[str]
    first_name: str
    last_name: str
    email: EmailStr
    password: str


class ParentRegister(BaseModel):
    invite_token: str
    email: EmailStr
    password: str
    first_name: str
    last_name: str


class ForgotRequest(BaseModel):
    email: EmailStr


class ResetRequest(BaseModel):
    token: str
    password: str
