from sqlalchemy import Column, Integer, String, ForeignKey, Boolean, DateTime
from sqlalchemy.orm import relationship
from datetime import datetime
from app.db.base import Base


class Invite(Base):
    __tablename__ = "invites"
    id = Column(Integer, primary_key=True, index=True)
    token = Column(String, unique=True, index=True, nullable=False)
    role = Column(String, nullable=False)  # TRAINER or PARENT
    club_id = Column(Integer, ForeignKey("clubs.id", ondelete="CASCADE"), nullable=True)  # For parent invites
    created_by = Column(Integer, ForeignKey("users.id"), nullable=False)  # Admin who created invite
    created_at = Column(DateTime, nullable=False, default=datetime.utcnow)
    expires_at = Column(DateTime, nullable=False)
    used = Column(Boolean, default=False)
    used_at = Column(DateTime, nullable=True)
    used_by = Column(Integer, ForeignKey("users.id"), nullable=True)  # User who registered with this token
    revoked = Column(Boolean, default=False)
    revoked_at = Column(DateTime, nullable=True)
    
    club = relationship("Club", back_populates="invites")
