from sqlalchemy import Column, Integer, String, ForeignKey
from sqlalchemy.orm import relationship
from app.db.base import Base


class Club(Base):
    __tablename__ = "clubs"
    id = Column(Integer, primary_key=True, index=True)
    name = Column(String, nullable=False)
    city = Column(String, nullable=True)
    admin_id = Column(Integer, ForeignKey("users.id"), nullable=True)  # Admin who manages this club

    admin = relationship("User", foreign_keys=[admin_id], back_populates="managed_clubs")
    users = relationship("User", foreign_keys="User.club_id", back_populates="club", cascade="all, delete-orphan")
    children = relationship("Child", back_populates="club", cascade="all, delete-orphan")
    products = relationship("Product", back_populates="club", cascade="all, delete-orphan")
    invites = relationship("Invite", back_populates="club", cascade="all, delete-orphan")
